%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%----------Binomial Average Rule without Variance Reduction Trick----------

function[probability_of_choosing_treatment_1] = f_BAR_without_VR(treatment_1, treatment_2, ...
    lower_interval, upper_interval, accuracy);

%Normalizing the value of the treatment samples
normalized_treatment_1 = (treatment_1 - lower_interval) / (upper_interval - lower_interval);
normalized_treatment_2 = (treatment_2 - lower_interval) / (upper_interval - lower_interval);

%Dropping observations from the samples
n_1 = numel(treatment_1);
n_2 = numel(treatment_2);
if n_1 == n_2;
    montecarlo_drops = 10^0;
    accuracy = 2*accuracy;
elseif n_1 > n_2;
    montecarlo_drops = 10^(accuracy/2);
end;

drop = 0;
while drop < montecarlo_drops;
  drop = drop + 1;
  x = normalized_treatment_1;
    if n_1 > n_2;
    difference = n_1 - n_2;
    which_ones_to_drop = randsample(n_1,difference);
    x(which_ones_to_drop,:) = [];
else;end;
n = n_2;
y = normalized_treatment_2;

%Computing the better treatment
montecarlo_shots = 10^(accuracy/2);
shot = 0;
result = 0;
while shot < montecarlo_shots;
  shot = shot + 1;
  flipping_coins = rand(n,2);
  for i=1:1:n;
     if x(i,1) > flipping_coins(i,1);
       binary_x(i,1) = 1;
     else;
       binary_x(i,1) = 0;
     end;
     if y(i,1) > flipping_coins(i,2);
       binary_y(i,1) = 1;
     else;
       binary_y(i,1) = 0;
     end;
  end;
  sum_binary_x = sum(binary_x);
  sum_binary_y = sum(binary_y);

  if sum_binary_x > sum_binary_y;
    result = result + (1 / montecarlo_shots);
  elseif sum_binary_x < sum_binary_y;
  else;
    result = result + (.5 / montecarlo_shots);
  end;

end; %Ending the 'Computing better treatment' loop
probability_of_choosing_treatment_1_on_this_drop(drop,1) = result;
end; %Ending the 'Dropping observations from the samples' loop
probability_of_choosing_treatment_1 = sum(probability_of_choosing_treatment_1_on_this_drop) / montecarlo_drops;